/*
 * wxJavaScript - staticbx.h
 *
 * Copyright (c) 2002-2007 Franky Braem and the wxJavaScript project
 *
 * Project Info: http://www.wxjavascript.net or http://wxjs.sourceforge.net
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 * $Id: staticbx.h 694 2007-05-03 21:14:13Z fbraem $
 */
#ifndef _WXJSStaticBox_H
#define _WXJSStaticBox_H

namespace wxjs
{
    namespace gui
    {
        class StaticBox : public ApiWrapper<StaticBox, wxStaticBox>
        {
        public:

          static bool AddProperty(wxStaticBox *p, 
                                  JSContext *cx, 
                                  JSObject *obj, 
                                  const wxString &prop, 
                                  jsval *vp);
          static bool DeleteProperty(wxStaticBox *p, 
                                     JSContext* cx, 
                                     JSObject* obj, 
                                     const wxString &prop);
          static wxStaticBox* Construct(JSContext *cx,
                                        JSObject *obj,
                                        uintN argc,
                                        jsval *argv,
                                        bool constructing);	

          WXJS_DECLARE_METHOD_MAP()
          WXJS_DECLARE_METHOD(create)
        };
    }; // namespace gui
}; // namespace wxjs

#endif //_WXJSStaticBox_H
