/*
 * wxJavaScript - imagelst.h
 *
 * Copyright (c) 2002-2007 Franky Braem and the wxJavaScript project
 *
 * Project Info: http://www.wxjavascript.net or http://wxjs.sourceforge.net
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 * $Id: imagelst.h 715 2007-05-18 20:38:04Z fbraem $
 */
#ifndef _WXJSImageList_H
#define _WXJSImageList_H

#include <wx/imaglist.h>

namespace wxjs
{
    namespace gui
    {
      class ImageList : public ApiWrapper<ImageList, ImageList>
                      , public wxImageList
                      , public wxClientDataContainer
        {
        public:

          ImageList();
          virtual ~ImageList() {}

          static bool GetProperty(wxImageList *p,
                                  JSContext *cx,
                                  JSObject *obj,
                                  int id,
                                  jsval *vp);
          static ImageList* Construct(JSContext *cx,
                                      JSObject *obj,
                                      uintN argc,
                                      jsval *argv,
                                      bool constructing);

          WXJS_DECLARE_PROPERTY_MAP()

          /**
           * Property Ids.
           */
          enum
          {
              P_IMAGE_COUNT
          };

          WXJS_DECLARE_METHOD_MAP()
          WXJS_DECLARE_METHOD(add)
          WXJS_DECLARE_METHOD(create)
          WXJS_DECLARE_METHOD(draw)
          WXJS_DECLARE_METHOD(getSize)
          WXJS_DECLARE_METHOD(remove)
          WXJS_DECLARE_METHOD(replace)
          WXJS_DECLARE_METHOD(removeAll)

        };
    }; // namespace gui
}; // namespace wxjs

#endif //_WXJSImageList_H

